#include <IRremote.h>
// can be set to any pin
IRrecv irrecv(11);

#include "Keyboard.h"
#include "Mouse.h"

void setup() {
  delay(1000);
  Mouse.begin();         //mouse
  Keyboard.begin();     //keyboard
  irrecv.enableIRIn();   //IR receiver
}

void loop() {
  decode_results  results;        //struct for results of IR rx
  static unsigned long lastcode=0;
  unsigned long code;  
  if (irrecv.decode(&results)) {    //decode
    code=results.value;
    irrecv.resume();
    //Serial.println(code,HEX);
    if(code==0xFFFFFFFF){code=lastcode;}                  //emulate NEC repeat
    if(code==0xFF18E7){Mouse.move(0,-10);}                //XC3718_2 (up)
    if(code==0xFF10EF){Mouse.move(-10,0);}                //XC3718_4 (left)
    if(code==0xFF5AA5){Mouse.move(10,0);}                 //XC3718_6 (right)
    if(code==0xFF4AB5){Mouse.move(0,10);}                 //XC3718_8 (down)
    if(code==0xFF30CF){Mouse.move(-10,-10);}              //XC3718_1 (up left)
    if(code==0xFF7A85){Mouse.move(10,-10);}               //XC3718_3 (up right)
    if(code==0xFF42BD){Mouse.move(-10,10);}               //XC3718_7 (down left)
    if(code==0xFF52AD){Mouse.move(10,10);}                //XC3718_9 (down right)
    if(code==0xFF38C7){Mouse.click(MOUSE_LEFT);code=0;}   //XC3718_5 (click), clear to avoid repeats on click
    if(code==0xFFC23D){Keyboard.write(' ');code=0;}       //XC3718_PLAYPAUSE, no repeats
    if(code==0xFF22DD){                                   //XC3718_PREV
      Keyboard.press(KEY_LEFT_ALT);
      Keyboard.press(KEY_LEFT_ARROW);
      delay(100);
      Keyboard.releaseAll();      
      code=0;
    }
    if(code==0xFF02FD){                       //XC3718_NEXT
      Keyboard.press(KEY_LEFT_ALT);
      Keyboard.press(KEY_RIGHT_ARROW);
      delay(100);
      Keyboard.releaseAll();            
      code=0;
    }
    lastcode=code;                            //save if needed for repeats
  }  
}

/* List of codes for Jaycar XC3718 remote control

    if(code==0xFFA25D){}      //XC3718_CHMINUS
    if(code==0xFF629D){}      //XC3718_CH
    if(code==0xFFE21D){}      //XC3718_CHPLUS
    if(code==0xFF22DD){}      //XC3718_PREV
    if(code==0xFF02FD){}      //XC3718_NEXT
    if(code==0xFFC23D){}      //XC3718_PLAYPAUSE
    if(code==0xFFE01F){}      //XC3718_VOLMINUS
    if(code==0xFFA857){}      //XC3718_VOLPLUS
    if(code==0xFF906F){}      //XC3718_EQ
    if(code==0xFF6897){}      //XC3718_0
    if(code==0xFF9867){}      //XC3718_100PLUS
    if(code==0xFFB04F){}      //XC3718_200PLUS
    if(code==0xFF30CF){}      //XC3718_1
    if(code==0xFF18E7){}      //XC3718_2
    if(code==0xFF7A85){}      //XC3718_3
    if(code==0xFF10EF){}      //XC3718_4
    if(code==0xFF38C7){}      //XC3718_5
    if(code==0xFF5AA5){}      //XC3718_6
    if(code==0xFF42BD){}      //XC3718_7
    if(code==0xFF4AB5){}      //XC3718_8
    if(code==0xFF52AD){}      //XC3718_9
 
 
 */

